package com.agilex.healthcare.directscheduling.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIgnoreProperties(ignoreUnknown = true)
@XmlRootElement(name = "facilityTeamClinic", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class FacilityMemberClinic extends FacilityMember {
	private String locationSID;
	private String locationIEN;
	private String locationType;
	private String locationName;
	private String primaryStopCode;
	private String primaryStopCodeName;
	private String secondaryStopCode;
	private String secondaryStopCodeName;
	private String physicalLocation;
	private String institutionSID;
	private String institutionIEN;
	private String institutionName;
	private String institutionCode;
	private String teamSID;
	private String team;
	private String teamPurpose;
    private String friendlyLocationName;
    private String schedulingFlag;
    private String displayAppointmentFlag;

	public String getFriendlyLocationName() {
		return friendlyLocationName;
	}

	public void setFriendlyLocationName(String friendlyLocationName) {
		this.friendlyLocationName = friendlyLocationName;
	}

	@XmlElement
	public String getSchedulingFlag() {
		return schedulingFlag;
	}

	public void setSchedulingFlag(String schedulingFlag) {
		this.schedulingFlag = schedulingFlag;
	}
	@XmlElement
	public String getDisplayAppointmentFlag() {
		return displayAppointmentFlag;
	}

	public void setDisplayAppointmentFlag(String displayAppointmentFlag) {
		this.displayAppointmentFlag = displayAppointmentFlag;
	}

	public String getLocationSID() {
		return locationSID;
	}

	public void setLocationSID(String locationSID) {
		this.locationSID = locationSID;
	}

	@JsonProperty("locationIEN")
	public String getLocationIEN() {
		return locationIEN;
	}

	public void setLocationIEN(String locationIEN) {
		this.locationIEN = locationIEN;
	}

	public String getLocationType() {
		return locationType;
	}

	public void setLocationType(String locationType) {
		this.locationType = locationType;
	}

	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}

	public String getPrimaryStopCode() {
		return primaryStopCode;
	}

	public void setPrimaryStopCode(String primaryStopCode) {
		this.primaryStopCode = primaryStopCode;
	}

	public String getPrimaryStopCodeName() {
		return primaryStopCodeName;
	}

	public void setPrimaryStopCodeName(String primaryStopCodeName) {
		this.primaryStopCodeName = primaryStopCodeName;
	}

	public String getSecondaryStopCode() {
		return secondaryStopCode;
	}

	public void setSecondaryStopCode(String secondaryStopCode) {
		this.secondaryStopCode = secondaryStopCode;
	}

	public String getSecondaryStopCodeName() {
		return secondaryStopCodeName;
	}

	public void setSecondaryStopCodeName(String secondaryStopCodeName) {
		this.secondaryStopCodeName = secondaryStopCodeName;
	}

	@JsonProperty("physicalLocation")
	public String getPhysicalLocation() {
		return physicalLocation;
	}

	public void setPhysicalLocation(String physicalLocation) {
		this.physicalLocation = physicalLocation;
	}

	public String getInstitutionSID() {
		return institutionSID;
	}

	public void setInstitutionSID(String institutionSID) {
		this.institutionSID = institutionSID;
	}

	public String getInstitutionIEN() {
		return institutionIEN;
	}

	public void setInstitutionIEN(String institutionIEN) {
		this.institutionIEN = institutionIEN;
	}

	public String getInstitutionName() {
		return institutionName;
	}

	public void setInstitutionName(String institutionName) {
		this.institutionName = institutionName;
	}

	public String getInstitutionCode() {
		return institutionCode;
	}

	public void setInstitutionCode(String institutionCode) {
		this.institutionCode = institutionCode;
	}

	public String getTeamSID() {
		return teamSID;
	}

	public void setTeamSID(String teamSID) {
		this.teamSID = teamSID;
	}

	public String getTeamName() {
		return team;
	}

	public void setTeamName(String team) {
		this.team = team;
	}

	public String getTeamPurpose() {
		return teamPurpose;
	}

	public void setTeamPurpose(String teamPurpose) {
		this.teamPurpose = teamPurpose;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();

		sb.append("LocationSID=" + locationSID).append("\r\n");
		sb.append("LocationIEN=" + locationIEN).append("\r\n");
		sb.append("FacilityId=" + super.getFacilityId()).append("\r\n");
		sb.append("LocationType=" + locationType).append("\r\n");
		sb.append("LocationName=" + locationName).append("\r\n");
		sb.append("PrimaryStopCode=" + primaryStopCode).append("\r\n");
		sb.append("PrimaryStopCodeName=" + primaryStopCodeName).append("\r\n");
		sb.append("PhysicalLocation=" + physicalLocation).append("\r\n");
		sb.append("InstitutionSID=" + institutionSID).append("\r\n");
		sb.append("InstitutionIEN=" + institutionIEN).append("\r\n");
		sb.append("InstituationName=" + institutionName).append("\r\n");
		sb.append("InsitutationCode=" + institutionCode).append("\r\n");
		sb.append("TeamSID=" + teamSID).append("\r\n");
		sb.append("TeamName=" + team).append("\r\n");
		sb.append("TeamPurpose=" + teamPurpose).append("\r\n");
		sb.append("FriendlyLocationName=" + friendlyLocationName).append("\r\n");
		sb.append("SchedulingFlag=" + schedulingFlag).append("\r\n");
		sb.append("DisplayAppointmentFlag=" + displayAppointmentFlag).append("\r\n");

		return (sb.toString());
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((super.getFacilityId() == null) ? 0 : super.getFacilityId().hashCode());
		result = prime * result
				+ ((locationIEN == null) ? 0 : locationIEN.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FacilityMemberClinic other = (FacilityMemberClinic) obj;
		if (super.getFacilityId() == null) {
			if (other.institutionSID != null)
				return false;
		} else if (!super.getFacilityId().equals(other.getFacilityId()))
			return false;
		if (locationIEN == null) {
			if (other.locationIEN != null)
				return false;
		} else if (!locationIEN.equals(other.locationIEN))
			return false;
		return true;
	}
}